(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     27135,        725]
NotebookOptionsPosition[     25958,        678]
NotebookOutlinePosition[     26300,        693]
CellTagsIndexPosition[     26257,        690]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Visualization", "Title",
 CellChangeTimes->{{3.6881970970267234`*^9, 3.688197099071419*^9}}],

Cell[CellGroupData[{

Cell["Harmonic Oscillator", "Chapter",
 CellChangeTimes->{{3.688197105750081*^9, 3.6881971082918186`*^9}}],

Cell[CellGroupData[{

Cell["Create a figure", "Section",
 CellChangeTimes->{{3.688196226187497*^9, 3.6881962283383927`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "$HomeDirectory", ",", "\"\<Desktop\>\"", ",", "\"\<output.dat\>\""}], 
      "}"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Dimensions", "[", "data", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotxp", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<position x\>\"", ",", "\"\<momentum  p\>\""}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"20", ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "Black", 
        ",", 
        RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "500"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "\n", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"plotTimeseries", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"data", "\[Transpose]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<timestep t\>\"", ",", "\"\<variable\>\""}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"20", ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "Black", 
        ",", 
        RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "500"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<position x\>\"", ",", "\"\<momentum p\>\""}], "}"}]}]}], 
    "\n", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot", "=", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"plotxp", ",", "plotTimeseries"}], "}"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "$HomeDirectory", ",", "\"\<Desktop\>\"", ",", "\"\<pic_ho.png\>\""}], 
     "}"}], "]"}], ",", "plot"}], "]"}]}], "Input",
 CellChangeTimes->{{3.639286577304489*^9, 3.639286605437098*^9}, {
   3.639637606158762*^9, 3.6396376200385556`*^9}, 3.6881970717819595`*^9, {
   3.688197148687319*^9, 3.688197154252905*^9}, 3.6881975649204216`*^9, {
   3.6881977860672674`*^9, 3.688197839564005*^9}, {3.688205671671327*^9, 
   3.6882056920586753`*^9}, {3.6882057303894105`*^9, 3.68820574843983*^9}, 
   3.6882059949125676`*^9, {3.6882060305220256`*^9, 3.6882060991231966`*^9}, {
   3.688206467403597*^9, 3.688206497635435*^9}, {3.688206739976942*^9, 
   3.688206742944003*^9}, 3.6882215955166225`*^9, {3.6882217064899406`*^9, 
   3.688221707084973*^9}, {3.6882217510376334`*^9, 3.688221855584255*^9}, {
   3.6882314738495655`*^9, 3.6882314798498526`*^9}, {3.688231520599185*^9, 
   3.688231530600625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create an animation", "Section",
 CellChangeTimes->{{3.6881962433495946`*^9, 3.6881962458687897`*^9}, 
   3.6881970774387903`*^9}],

Cell["\<\
use VirtualDub or ffmpeg to create movie/animation from image sequence\
\>", "Text",
 CellChangeTimes->{{3.68821113875692*^9, 3.68821114927644*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "$HomeDirectory", ",", "\"\<Desktop\>\"", ",", "\"\<output.dat\>\""}], 
      "}"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Dimensions", "[", "data", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pthout", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "$HomeDirectory", ",", "\"\<Desktop\>\"", ",", "\"\<mmamovie\>\""}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"FileExistsQ", "[", "#", "]"}]}], ",", 
       RowBox[{"CreateDirectory", "[", "#", "]"}]}], "]"}], "&"}], "@", 
    "pthout"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"di", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"counter", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"plotxp", "=", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{"data", ",", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<position x\>\"", ",", "\"\<momentum  p\>\""}], "}"}]}],
         ",", 
        RowBox[{"FrameStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"20", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
           "Black", ",", 
           RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "500"}], ",", "\[IndentingNewLine]", 
        RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"plotTimeseries", "=", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"data", "\[Transpose]"}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<timestep t\>\"", ",", "\"\<variable\>\""}], "}"}]}], 
        ",", 
        RowBox[{"FrameStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"20", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
           "Black", ",", 
           RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "500"}], ",", "\[IndentingNewLine]", 
        RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<position x\>\"", ",", "\"\<momentum p\>\""}], 
          "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"plot", "=", 
      RowBox[{"Grid", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"plotxp", ",", "plotTimeseries"}], "}"}], "}"}], "]"}]}], 
     ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"pthout", ",", 
          RowBox[{"\"\<pic_\>\"", "<>", 
           RowBox[{"IntegerString", "[", 
            RowBox[{
             RowBox[{"counter", "++"}], ",", "10", ",", 
             RowBox[{
              RowBox[{"IntegerLength", "[", 
               RowBox[{"Length", "@", "data"}], "]"}], "+", "1"}]}], "]"}], 
           "<>", "\"\<.png\>\""}]}], "}"}], "]"}], ",", "plot"}], "]"}], 
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}], ",", "di"}], "}"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.639286577304489*^9, 3.639286605437098*^9}, {
   3.639637606158762*^9, 3.6396376200385556`*^9}, 3.6881970717819595`*^9, {
   3.688197148687319*^9, 3.688197154252905*^9}, {3.6881975591402617`*^9, 
   3.6881975595962133`*^9}, {3.6881978569183965`*^9, 3.6881978578172503`*^9}, 
   3.688205703195403*^9, 3.688205754113569*^9, {3.6882061906000156`*^9, 
   3.6882064446040525`*^9}, {3.6882065143964863`*^9, 
   3.6882065755879107`*^9}, {3.688206667253892*^9, 3.6882068503968925`*^9}, {
   3.688206897582369*^9, 3.6882068984154987`*^9}, {3.6882069499825077`*^9, 
   3.6882070016151*^9}, {3.688207073664919*^9, 3.688207094268756*^9}, {
   3.688221686952047*^9, 3.688221687420563*^9}, {3.6882314952073154`*^9, 
   3.6882315055248966`*^9}, {3.688231538681486*^9, 3.688231542764102*^9}, {
   3.68823182554202*^9, 3.6882318365805483`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Love affair dynamics", "Chapter",
 CellChangeTimes->{{3.688197113883565*^9, 3.6881971241688924`*^9}}],

Cell[CellGroupData[{

Cell["Create a figure", "Section",
 CellChangeTimes->{{3.688196226187497*^9, 3.6881962283383927`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "$HomeDirectory", ",", "\"\<Desktop\>\"", ",", "\"\<output.dat\>\""}], 
      "}"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Dimensions", "[", "data", "]"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "@", "data"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Romeo's love R\>\"", ",", "\"\<Julia's love J\>\""}], 
       "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"20", ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        "Black"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "500"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "\n", "]"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "$HomeDirectory", ",", "\"\<Desktop\>\"", ",", "\"\<pic_love.png\>\""}], 
     "}"}], "]"}], ",", "plot"}], "]"}]}], "Input",
 CellChangeTimes->{{3.639286577304489*^9, 3.639286605437098*^9}, {
   3.639637606158762*^9, 3.6396376200385556`*^9}, 3.6881970717819595`*^9, 
   3.6881975754546595`*^9, 3.688205709083273*^9, 3.6882057599428263`*^9, {
   3.6882071364078035`*^9, 3.6882071410730057`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Double pendulum", "Chapter",
 CellChangeTimes->{{3.688197105750081*^9, 3.6881971082918186`*^9}, {
  3.688197765637781*^9, 3.6881977685762806`*^9}}],

Cell[CellGroupData[{

Cell["Create a live animation in Mathematica", "Section",
 CellChangeTimes->{{3.6881962433495946`*^9, 3.6881962458687897`*^9}, 
   3.6881970774387903`*^9, {3.688224846892477*^9, 3.688224864390435*^9}}],

Cell["\<\
use VirtualDub or ffmpeg to create movie/animation from image sequence
sample ffmpeg command: 
ffmpeg -framerate 30 -i \
\[OpenCurlyDoubleQuote]C:\\Users\\Jan\\Desktop\\mmamovie\\pic_%05d.png\
\[CloseCurlyDoubleQuote] -vf \
scale=\[CloseCurlyDoubleQuote]trunc(iw/8)*8:trunc(ih/8)*8\
\[CloseCurlyDoubleQuote] -y -vcodec libx264 -pix_fmt yuv420p -preset slow \
-crf 18 -r 30 \[OpenCurlyDoubleQuote]C:\\Users\\Jan\\Desktop\\animation.mp4\
\[CloseCurlyDoubleQuote]\
\>", "Text",
 CellChangeTimes->{{3.688223825491969*^9, 3.6882239076844916`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "$HomeDirectory", ",", "\"\<Desktop\>\"", ",", "\"\<output.dat\>\""}], 
      "}"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"l1", ",", "l2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1.0", ",", "1.0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xy1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"l1", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"data", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"-", "l1"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"data", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}]}], "}"}], 
    "\[Transpose]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xy2", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"l1", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "+", 
        RowBox[{"l2", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "l1"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "-", 
        RowBox[{"l2", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}]}], "}"}], 
     "\[Transpose]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"di", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plot", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Lighter", "@", "Gray"}], ",", 
        RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"xy1", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", 
           RowBox[{"xy2", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], ",", "Black", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"xy1", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "0.07"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"xy2", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "0.07"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "0.03"}], "]"}]}], "}"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<position x\>\"", ",", "\"\<position y\>\""}], "}"}]}], 
      ",", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"20", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "Black",
          ",", 
         RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "400"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"1.1", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "0.1"}], "}"}]}], "}"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "@", "data"}], ",", "di", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}], ",", 
     RowBox[{"AnimationRate", "\[Rule]", "50"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.639286577304489*^9, 3.639286605437098*^9}, {
   3.639637606158762*^9, 3.6396376200385556`*^9}, 3.6881970717819595`*^9, {
   3.688197148687319*^9, 3.688197154252905*^9}, {3.6881975591402617`*^9, 
   3.6881975595962133`*^9}, {3.6881978569183965`*^9, 3.6881978578172503`*^9}, 
   3.688205703195403*^9, 3.688205754113569*^9, {3.6882061906000156`*^9, 
   3.6882064446040525`*^9}, {3.6882065143964863`*^9, 
   3.6882065755879107`*^9}, {3.688206667253892*^9, 3.6882068503968925`*^9}, {
   3.688206897582369*^9, 3.6882068984154987`*^9}, {3.6882069499825077`*^9, 
   3.6882070016151*^9}, {3.688207073664919*^9, 3.688207094268756*^9}, {
   3.688207227707346*^9, 3.6882072519538555`*^9}, {3.6882234802950335`*^9, 
   3.6882234828320713`*^9}, {3.6882235185042915`*^9, 3.6882235426554236`*^9}, 
   3.6882236942742605`*^9, {3.6882239818394203`*^9, 3.688223991320112*^9}, {
   3.688224055186845*^9, 3.6882240610541277`*^9}, {3.688224132117153*^9, 
   3.6882242459792747`*^9}, {3.6882243304182816`*^9, 3.688224332933339*^9}, {
   3.6882248768722124`*^9, 3.6882248933485985`*^9}, {3.688224944314331*^9, 
   3.688224944445754*^9}, {3.6882249989147577`*^9, 3.6882250031469345`*^9}, {
   3.6882308132031326`*^9, 3.688230846970149*^9}, {3.6882309059146633`*^9, 
   3.688230948499011*^9}, {3.688230992343652*^9, 3.688231097917443*^9}, {
   3.6882311492395535`*^9, 3.688231167215436*^9}, {3.688231269659457*^9, 
   3.6882312788288083`*^9}, {3.6882313534651127`*^9, 3.688231383019982*^9}, {
   3.688231571241811*^9, 3.688231636448544*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create an animation from an image sequence", "Section",
 CellChangeTimes->{{3.6881962433495946`*^9, 3.6881962458687897`*^9}, 
   3.6881970774387903`*^9, {3.688224846892477*^9, 3.6882248514919033`*^9}}],

Cell["\<\
use VirtualDub or ffmpeg to create movie/animation from image sequence
sample ffmpeg command: 
ffmpeg -framerate 30 -i \
\[OpenCurlyDoubleQuote]C:\\Users\\Jan\\Desktop\\mmamovie\\pic_%05d.png\
\[CloseCurlyDoubleQuote] -vf \
scale=\[CloseCurlyDoubleQuote]trunc(iw/8)*8:trunc(ih/8)*8\
\[CloseCurlyDoubleQuote] -y -vcodec libx264 -pix_fmt yuv420p -preset slow \
-crf 18 -r 30 \[OpenCurlyDoubleQuote]C:\\Users\\Jan\\Desktop\\animation.mp4\
\[CloseCurlyDoubleQuote]\
\>", "Text",
 CellChangeTimes->{{3.688223825491969*^9, 3.6882239076844916`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "$HomeDirectory", ",", "\"\<Desktop\>\"", ",", "\"\<output.dat\>\""}], 
      "}"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Dimensions", "[", "data", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"l1", ",", "l2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1.0", ",", "1.0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xy1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"l1", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"data", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"-", "l1"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"data", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}]}], "}"}], 
    "\[Transpose]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xy2", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"l1", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "+", 
        RowBox[{"l2", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "l1"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "-", 
        RowBox[{"l2", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}]}], "}"}], 
     "\[Transpose]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pthout", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "$HomeDirectory", ",", "\"\<Desktop\>\"", ",", "\"\<mmamovie\>\""}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"FileExistsQ", "[", "#", "]"}]}], ",", 
       RowBox[{"CreateDirectory", "[", "#", "]"}]}], "]"}], "&"}], "@", 
    "pthout"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"di", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"counter", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"plot", "=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Lighter", "@", "Gray"}], ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"xy1", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"xy2", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], ",", "Black", 
          ",", 
          RowBox[{"Disk", "[", 
           RowBox[{
            RowBox[{"xy1", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", "0.07"}], "]"}], ",", 
          RowBox[{"Disk", "[", 
           RowBox[{
            RowBox[{"xy2", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", "0.07"}], "]"}], ",", 
          RowBox[{"Disk", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "0.03"}], "]"}]}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<position x\>\"", ",", "\"\<position y\>\""}], "}"}]}], 
        ",", 
        RowBox[{"FrameStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"20", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
           "Black", ",", 
           RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "400"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Axes", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"1.1", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "0.1"}], "}"}]}], "}"}]}]}]}], 
       "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"pthout", ",", 
          RowBox[{"\"\<pic_\>\"", "<>", 
           RowBox[{"IntegerString", "[", 
            RowBox[{
             RowBox[{"counter", "++"}], ",", "10", ",", 
             RowBox[{
              RowBox[{"IntegerLength", "[", 
               RowBox[{"Length", "@", "data"}], "]"}], "+", "1"}]}], "]"}], 
           "<>", "\"\<.png\>\""}]}], "}"}], "]"}], ",", "plot"}], "]"}], 
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "data"}], ",", "di"}], "}"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.639286577304489*^9, 3.639286605437098*^9}, {
   3.639637606158762*^9, 3.6396376200385556`*^9}, 3.6881970717819595`*^9, {
   3.688197148687319*^9, 3.688197154252905*^9}, {3.6881975591402617`*^9, 
   3.6881975595962133`*^9}, {3.6881978569183965`*^9, 3.6881978578172503`*^9}, 
   3.688205703195403*^9, 3.688205754113569*^9, {3.6882061906000156`*^9, 
   3.6882064446040525`*^9}, {3.6882065143964863`*^9, 
   3.6882065755879107`*^9}, {3.688206667253892*^9, 3.6882068503968925`*^9}, {
   3.688206897582369*^9, 3.6882068984154987`*^9}, {3.6882069499825077`*^9, 
   3.6882070016151*^9}, {3.688207073664919*^9, 3.688207094268756*^9}, {
   3.688207227707346*^9, 3.6882072519538555`*^9}, {3.6882234802950335`*^9, 
   3.6882234828320713`*^9}, {3.6882235185042915`*^9, 3.6882235426554236`*^9}, 
   3.6882236942742605`*^9, {3.6882239818394203`*^9, 3.688223991320112*^9}, {
   3.688224055186845*^9, 3.6882240610541277`*^9}, {3.688224132117153*^9, 
   3.6882242459792747`*^9}, {3.6882243304182816`*^9, 3.688224332933339*^9}, {
   3.6882249533316383`*^9, 3.688224980999476*^9}, {3.6882311882235575`*^9, 
   3.68823119088671*^9}, {3.6882312224715753`*^9, 3.68823124840731*^9}, {
   3.688231287908865*^9, 3.6882313062683268`*^9}, 3.6882313363770156`*^9, {
   3.688231400760893*^9, 3.6882314088397064`*^9}, {3.6882316463266*^9, 
   3.688231675192066*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1902, 976},
WindowMargins->{{-9, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 98, 1, 101, "Title"],
Cell[CellGroupData[{
Cell[702, 27, 106, 1, 72, "Chapter"],
Cell[CellGroupData[{
Cell[833, 32, 102, 1, 70, "Section"],
Cell[938, 35, 3253, 75, 244, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4228, 115, 136, 2, 70, "Section"],
Cell[4367, 119, 158, 3, 30, "Text"],
Cell[4528, 124, 4737, 112, 396, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9314, 242, 107, 1, 72, "Chapter"],
Cell[CellGroupData[{
Cell[9446, 247, 102, 1, 70, "Section"],
Cell[9551, 250, 1560, 39, 168, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11160, 295, 153, 2, 61, "Chapter"],
Cell[CellGroupData[{
Cell[11338, 301, 201, 2, 70, "Section"],
Cell[11542, 305, 552, 11, 68, "Text"],
Cell[12097, 318, 5963, 149, 299, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18097, 472, 207, 2, 70, "Section"],
Cell[18307, 476, 552, 11, 68, "Text"],
Cell[18862, 489, 7056, 184, 415, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

