// comment: here be a description of this program
// compile with: 
// WIN: g++ -Wall -O3 -static-libstdc++ -static-libgcc -std=c++0x solver.cpp -o solver.exe
// Linux: g++ -Wall -O3 -std=c++0x solver.cpp -o solver.exe

#include <iostream>
#include <fstream>
#include <vector>

using namespace std;


void savedata(vector<float> &x_out, vector<float> &p_out, int saveLen){
	
	// custom commands for different operating systems
	#ifdef __MINGW32__
		ofstream out("C:\\Users\\Jan\\Desktop\\output.dat");	
	#elif __linux__
		ofstream out("/home/jan/Desktop/output.dat");
	#endif
	
	for(int i=0; i<saveLen; i++) out << x_out[i] << " " << p_out[i] << endl;
	out.close();
}

int main(){
	
	// parameters
	float dt=0.0001;
	int nsteps=350000;
	int savesteps=100;
	int saveLen=nsteps/savesteps;
	vector <float> x_out(saveLen);
	vector <float> p_out(saveLen);
	float xneu, pneu;
	
	// initial condition
	float x0=1.0;
	float p0=0.0;
	
	// model parameters
	float w2=1.0;
	
	// time integration
	float x=x0;
	float p=p0;
	
	int counter=0;
	for(int step=0; step<nsteps; step++){
		
		// status update
		if(!(step%100)) cout << "step: " << step << endl;
		
		// save data for output
		if(!(step%savesteps)){
			x_out[counter] = x;
			p_out[counter] = p;
			counter++;
		}
		
		// euler step
		xneu = x + dt*( p );
		pneu = p + dt*( -w2*x );
		
		// update state
		x=xneu;
		p=pneu;
	}
	
	// save data
	savedata(x_out,p_out,saveLen);

}
