/**
* This file (MainFrame.java) is part of the Euler Angle project. 
* 
* required files: niceGraphics package(tuShape.java,DrawPanelIn3D) and customTextField
* 
* used by: -
* 
* ---------------------------------------------------
*Hier started der Compiler, und das Fenster samt KontrollPanel wird aufgebaut. Die Hauptächlichen zeichen-
*routinen finden sich in DrawPanelIn3D.Java. 
* 

*
* @author Simon Kraeusel
*/

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import niceGraphics.*;

public class MainFrame extends JApplet implements ChangeListener, ActionListener{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 8731871807939998623L;
	JPanel controlPanel;
	DrawPanelIn3D graphicsPanel;
	Textfield_Slider angleSliderPhi= new Textfield_Slider(Textfield_Slider.VERTICAL,0,360,0,"<html><font size = +1> \u03c6</font></html>");
	Textfield_Slider angleSliderTheta= new Textfield_Slider(Textfield_Slider.VERTICAL,0,360,0,"<html><font size = +1> \u03d1</font></html>");
	Textfield_Slider angleSliderPsi= new Textfield_Slider(Textfield_Slider.VERTICAL,0,360,0,"<html><font size = +1> \u03c8</font></html>");
	JButton go = new JButton ("Start");
	customTextField[] textFields = new customTextField[3];
	
	public static void main(String[] args) {
		JApplet theApplet = new MainFrame();
        theApplet.init();         // Needed if overridden in applet
	}
	
	public void init(){
		//Execute a job on the event-dispatching thread:
	    //creating this applet's GUI.
	    try {
	        javax.swing.SwingUtilities.invokeAndWait(new Runnable() {
	            public void run() {
	    	        createAndShowGUI();
	            }
	        });
	    } catch (Exception e) {
	        System.err.println("createGUI didn't successfully complete");
	    }
	}
	
	private void createAndShowGUI(){
		JFrame frame = new JFrame("Euler Winkel");
	    //frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	    //frame.setPreferredSize(new Dimension(620,540));
	    JPanel thePanel = new JPanel(new BorderLayout());
	    //thePanel.setSize(600,500);
	    graphicsPanel = new DrawPanelIn3D(500,500);
	    graphicsPanel.setMaximumSize(new Dimension(500, 500));
	    JScrollPane scrollPane = new JScrollPane(graphicsPanel); //this panel is needed because DrawPanelIn3D is not resizable
	    scrollPane.setBorder(BorderFactory.createRaisedBevelBorder());
	    thePanel.add(scrollPane,BorderLayout.CENTER);
	    controlPanel = new JPanel();
	    //controlPanel.setPreferredSize(new Dimension(100, 500));
	    graphicsPanel.setLabel("Copyright \u00A9 2008 TU-Berlin (S.Kraeusel & J.Probst)", true);
	    initConrolPanel();
	    thePanel.add(this.controlPanel,BorderLayout.EAST);
	    frame.setContentPane(thePanel);                                   
	    frame.pack();
	    frame.setVisible(true);
	}
	private void initConrolPanel() {
		controlPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		controlPanel.setLayout(new BoxLayout(this.controlPanel, BoxLayout.PAGE_AXIS) );
		JPanel sliderPanel = new JPanel();
		sliderPanel.add(this.angleSliderPhi);
		sliderPanel.add(this.angleSliderTheta);
		sliderPanel.add(this.angleSliderPsi);
		angleSliderPhi.setTextFieldFormatString(angleSliderPhi.getTextFieldFormatString() + "\u00B0");
		angleSliderTheta.setTextFieldFormatString(angleSliderPhi.getTextFieldFormatString());
		angleSliderPsi.setTextFieldFormatString(angleSliderPhi.getTextFieldFormatString());
		sliderPanel.setBorder(BorderFactory.createTitledBorder("Direct"));
		this.controlPanel.add(sliderPanel);
		angleSliderPsi.addChangeListener(this);
		angleSliderTheta.addChangeListener(this);
		angleSliderPhi.addChangeListener(this);
		JPanel animationPanel= new JPanel();
		animationPanel.setBorder(BorderFactory.createTitledBorder("Animation"));
		animationPanel.setLayout(new BoxLayout(animationPanel,BoxLayout.PAGE_AXIS));
		JPanel[] textPanels = new JPanel[3];
		for (int i = 0; i < textFields.length; i++) {
			textFields[i]=new customTextField(0,360,3,70);
			textPanels[i] = new JPanel();
			animationPanel.add(textPanels[i]);
		}
		textPanels[0].add(new JLabel("<html><font size = +1> \u03c6</font></html>"));
		textPanels[0].add(textFields[0]);
		textPanels[1].add(new JLabel("<html><font size = +1> \u03d1</font></html>"));
		textPanels[1].add(textFields[1]);
		textPanels[2].add(new JLabel("<html><font size = +1> \u03c8</font></html>"));
		textPanels[2].add(textFields[2]);
		animationPanel.add(go);
		this.controlPanel.add(animationPanel);
		go.addActionListener(this);		
		
	}
	public void stateChanged(ChangeEvent arg0) {
		graphicsPanel.tester=false;
		graphicsPanel.setEulerAngles(this.angleSliderPsi.getValue()/180.0*Math.PI, 
				this.angleSliderTheta.getValue()/180.0*Math.PI, 
				this.angleSliderPhi.getValue()/180.0*Math.PI);
	}


	public void actionPerformed(ActionEvent arg0) {

		if (arg0.getSource()==go) {
			this.graphicsPanel.startAnimation(
					this.textFields[0].value()/180.0*Math.PI, 
					this.textFields[1].value()/180.0*Math.PI, 
					this.textFields[2].value()/180.0*Math.PI);
		}
	}
}
