import java.awt.BorderLayout;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.ParseException;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

/** 
 * JSlider with a JLabel on top and a JTextField on the bottom.
 * Version 0.4 - June 30th, 2008 
*/

public class Textfield_Slider extends JPanel implements ChangeListener {
	
	JLabel label;
	private JSlider slid;
	private JTextField tfield;
	private boolean TextFieldVisible = true;
	private double adjustValue = 1.0;
	private String formatString = "%.0f";//"%.2g";
	public static int VERTICAL = JSlider.VERTICAL;
	public static int HORIZONTAL = JSlider.HORIZONTAL;
	
	public Textfield_Slider(int orientation, int min, int max, int init, String caption) {
		slid = new JSlider(orientation, min, max, init);
		slid.setMinorTickSpacing(1);
		slid.setPaintTicks(false);
		//slid.setSnapToTicks(true);
		
		tfield = new JTextField(4);
		tfield.setText(""+init);
		
		label = new JLabel(caption);
		
		final ChangeListener slidlisten = new ChangeListener(){
            public void stateChanged(ChangeEvent ce) {
                JSlider source = (JSlider)ce.getSource();
                    int value = (int)source.getValue();
                    tfield.setText(String.format(formatString, Double.valueOf(value * adjustValue)));
                return;
            }
		};
		
		final DocumentListener fieldlisten = new DocumentListener(){
			public void insertUpdate(DocumentEvent e) {
				Document doc = (Document)e.getDocument();
				double value = 0.0;
				try {
					//use DecimalFormat() to take the locale into account, i.e. "understand" a comma
					value = new DecimalFormat().parse(doc.getText(0, doc.getLength())).doubleValue();
				} 
				catch (ParseException e1){ 
					System.out.println("ParseException: " + e1.getMessage());
				}
				catch (BadLocationException e2){} 
	
				value /= adjustValue;
				
				/*value =(value > max) ? max : value; 
				value =(value < min) ? min : value;*/
				
				slid.removeChangeListener(slidlisten);
				slid.setValue((int) Math.round(value));
				slid.addChangeListener(slidlisten);
				
				return;
			}
			public void removeUpdate(DocumentEvent e) {}

			public void changedUpdate(DocumentEvent e) {}
		};
			
		setLayout(new BorderLayout());
		//setBorder(BorderFactory.createEmptyBorder(3,0,3,0));

		//setBorder(UIManager.getBorder("TitledBorder.border"));
		
		slid.addChangeListener(slidlisten);
        tfield.getDocument().addDocumentListener(fieldlisten);
        slid.addChangeListener(this);
        
        if (orientation == VERTICAL){
        	//slid.setPreferredSize(new Dimension(25, max - min));
        	
	        label.setHorizontalAlignment(SwingConstants.CENTER);
	        tfield.setHorizontalAlignment(SwingConstants.RIGHT);
	        
	        add(label, BorderLayout.NORTH);
			add(slid, BorderLayout.CENTER);
			tfield.setVisible(TextFieldVisible);
			add(tfield, BorderLayout.SOUTH);
        }
        else {
        	//slid.setPreferredSize(new Dimension(max - min, slid.getPreferredSize().height));
        	label.setPreferredSize(new Dimension(
        					label.getPreferredSize().width + 5,
        					label.getPreferredSize().height));
        	
        	label.setVerticalAlignment(SwingConstants.TOP);
        	label.setHorizontalAlignment(SwingConstants.LEADING);
	        tfield.setHorizontalAlignment(SwingConstants.RIGHT);
	        
	        add(label, BorderLayout.LINE_START);
			add(slid, BorderLayout.CENTER);
			tfield.setVisible(TextFieldVisible);
			add(tfield, BorderLayout.LINE_END);
        }
		}
	
	
	public int getValue(){
		return slid.getValue();
	}
	
	public void setValue(int value){
		slid.setValue(value);
	}
	
	public boolean getValueIsAdjusting(){
		return slid.getValueIsAdjusting();
	}
	
	public int getMaximum(){
		return slid.getMaximum();
	}
	
	public void setMaximum(int value){
		slid.setMaximum(value);
	}
	
	public int getMinimum(){
		return slid.getMinimum();
	}
	
	public void setMinimum(int value){
		slid.setMinimum(value);
	}
	
	public void setTextFieldEditable(boolean editable){
		tfield.setEditable(editable);
	}
	
	public boolean getTextFieldEditable(){
		return tfield.isEditable();
	}
		
	public void setTextFieldVisible(boolean visible){
		TextFieldVisible = visible;
		tfield.setVisible(visible);
	}
	
	public boolean getTextFieldVisible(){
		return TextFieldVisible;
	}
	
	/**
	 * @param s Sets the string that is used to format the value that is shown in the TextField.
	 * <p>
	 * The default is "%.0f".
	 */
	public void setTextFieldFormatString(String s){
		formatString = s;
	}
	
	/**
	 * @return Returns the string that is used to format the value that is shown in the TextField.
	 */
	public String getTextFieldFormatString(){
		return formatString;
	}
	
	/**
	 * If you don't want the TextField do show the same value as the Slider, you can 
	 * adjust it by multiplying with value. 
	 * The TextField will then always show the value 
	 * textfield-value = slider-value * <b> value </b>.
	 * <p>
	 * The default is <b> value </b> = 1.0, which means, no adjusting.
	 *  
	 */
	public void setTextFieldAdjustValue(double value){
		if (value != 0.0 && !Double.isInfinite(value) && !Double.isNaN(value))
			adjustValue = value;
		tfield.setText(String.format(formatString, Double.valueOf(slid.getValue() * adjustValue)));
	}
	
	/**
	 * @return value = textfield-value / slider-value;
	 * <p>
	 * see {@link setTextFieldAdjustValue}
	 */
	public double getTextFieldAdjustValue(){
		return adjustValue;
	}
	
	/**
	 * Sets a size for the caption. 
	 * Only useful if more than one TextField_Slider are used, so the sliders 
	 * can align under/next to each other
	 * 
	 * @param newDimension the caption's new size in pixels 
	 */
	public void setCaptionSize(Dimension newDimension){
		label.setPreferredSize(newDimension);
	}
	
	/**
	 * Returns the caption's size. 
	 * Useful if more than one TextField_Slider are used, so the sliders 
	 * can align under/next to each other
	 * 
	 * @param newDimension the caption's new size in pixels 
	 */
	public Dimension getCaptionSize(){
		return label.getPreferredSize();
	}
	
	public void setPaintTicks(boolean arg0){
		slid.setPaintTicks(arg0);
	}
	
	public boolean getPaintTicks(){
		return slid.getPaintTicks();
	}
	
	public void setMajorTickSpacing(int n){
		slid.setMajorTickSpacing(n);
	}
	
	public int getMajorTickSpacing(){
		return slid.getMajorTickSpacing();
	}
	
	public void setMinorTickSpacing(int n){
		slid.setMinorTickSpacing(n);
	}
	
	public int getMinorTickSpacing(){
		return slid.getMinorTickSpacing();
	}
	
	public void setEnabled(boolean enabled){
		super.setEnabled(enabled);
		label.setEnabled(enabled);
		slid.setEnabled(enabled);
		tfield.setEnabled(enabled);
	}
	

	ChangeListener changelisten;
	boolean doesListen = false;
	
	public void addChangeListener(ChangeListener cl) {
		changelisten = cl;
		doesListen = true;
	}
	
	
	public void stateChanged(ChangeEvent e) {
		if(doesListen){
			changelisten.stateChanged(new ChangeEvent(this));
		}
	}	
		
}
