/**
* This file (DrawPanelIn3D.java) is part of the Euler Angle Project
* 
* required files: TUShape.java
* 
* used by: MainFrame.java
* 
* ---------------------------------------------------
* Hier befinden sich fast alle Zeichenroutinen. Das Drawpanel ist vom Typ JPanel, erstellt ein JLabel über 
* die Gesamte Größe und setzt dorthinen ein BufferedImage. Vom BufferedImage kann die Graphics2D Zeichenklasse
* geholt werden. die Funktion paintComponent(Graphics g) wird von repaint() aufgerufen. Dort befinden sich 
* dann alle nötigen zeichenfunktionen.(das Bild wird für jedes neue frame schwarz übermalt, dann neu gezeichnet)
*Außerdem kann hier die Animation gestartet werden in dem das Objekt um die EulerWinkel gedreht wird. 

*
* @author Simon Kraeusel
*/

package niceGraphics;


import java.awt.*;
import java.awt.event.*;
import java.awt.geom.GeneralPath;
import java.awt.image.*;
import javax.swing.*;
//import javax.swing.event.*;


public class DrawPanelIn3D extends JPanel implements ActionListener, MouseListener, MouseMotionListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private BufferedImage image;  // remembers drawing commands
    private Graphics2D g2;   
    private JLabel picture;
    private String text="dummy";
	private int previousMousePositionX=0;
	private int previousMousePositionY=0;
	private boolean button1Pressed = true;
	private boolean button2Pressed = false;
	private boolean button3Pressed = false;
	public boolean tester=false;
	private TUShape tu = new TUShape();

   
    public static final int DELAY = 500;
    
    private boolean labelisVisible = false;
    private String label = "";
    
    public static void main(String[] args){
    	javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
    private static void createAndShowGUI(){ 
		JFrame frame = new JFrame("SHAPES");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               
        DrawPanelIn3D thePanel = new DrawPanelIn3D(600,600);

        frame.setContentPane(thePanel);                                   
        frame.pack();
        frame.setVisible(true);
	}
	
	public DrawPanelIn3D(int xSize, int ySize){
		
		this.image = new BufferedImage(xSize,ySize, BufferedImage.TYPE_INT_ARGB);
        this.setPreferredSize(new Dimension(xSize,ySize));
        this.setBackground(Color.BLACK);
        this.picture = new JLabel(new ImageIcon(image));
        this.picture.setVisible(true);
        this.picture.setBackground(Color.BLACK);
        this.add(picture);       
        this.g2 = (Graphics2D)image.getGraphics();
        this.g2.setColor(Color.BLACK);
        new Timer(DELAY, this).start();//fires the actionListener every half second
        this.addMouseMotionListener(this);     
        this.addMouseListener(this);
        
	}
	
	/**
	 * sets the euler angles for the TUShapes coordinate system 
	 * (a coordinate system embedded in a Coordinate System that can be rotated by mouse input)
	 * @param phi
	 * @param theta
	 * @param psi
	 */
	public void setEulerAngles(double phi, double theta, double psi){
		tu.setEulerAngles(phi, theta, psi);
		repaint();
	}
	
	/**
	 * sets the Origin of the coordinate Systems in which tuShape is drawn
	 * @param x
	 * @param y
	 * @param z
	 */
	public void setCOSOrigin(int x, int y, int z){
		tu.setOrigin(x, y, z);
		this.repaint();
	}
	
	/**
	 * is called by the repaint command and draws everything that is necessary.
	 * It also calls the super function. Maybe it would be better to draw everything with the input parameter
	 * g instead of calling the graphics g2 of the buffered image to draw the 3d Shapes?But again, I think it 
	 * would bypass then the whole Graphics2D buisness of the buffered image, since the g is only Graphics.
	 * g is used to draw the whole class (extended JPanel), while bufferedImage -> Graphics2D would use new,
	 * better drawingcommands.
	 */
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		
		g2.setColor(Color.black);
		g2.fillRect(0,0,600,600);
		g2.setColor(Color.white);
		tu.drawDashedLine(g2,Color.red);
		g2.setStroke(new BasicStroke(2, BasicStroke.CAP_BUTT,BasicStroke.JOIN_ROUND));
		tu.drawEulerMovedCoordinateSystem(g2, Color.red);

		tu.drawCoordinateSystem(g2, Color.green);
		g2.setColor(Color.white);
		g2.setStroke(new BasicStroke());
		tu.drawTUShape((Graphics2D)g2);
		if(tester){
			this.drawAngleRep();
			tu.drawAngleLabel(g2);
		}
		
		if (labelisVisible){
			g2.setColor(Color.WHITE);
			g2.drawString(label, 10, image.getHeight() - 25);
		}
		
		//g2.drawString("\u03c6", 20, 50);
		
		/*g2.setColor(Color.lightGray);
    	g2.fillRect(10, 10, 250, 20);
    	g2.setColor(Color.black);
    	g2.drawString(text,25,25);*/
    	
	}
	
	public void setLabel(String llabel, boolean setVisible){
		labelisVisible = setVisible;
		this.label = llabel;
	}
	
	public Graphics2D getTheGraphics() {
        return this.g2;					
    }
    
	/**
	 * can be used to get the image directly in order to alter it pixel by pixel instead through the
	 * graphics2D class
	 * @return
	 */
    public BufferedImage getImage(){
    	return this.image;
    }
    
    public void pictureVisible(boolean x){
       	this.picture.setVisible(x);	    
    }
    
    public void setImage(BufferedImage glo){
    	this.remove(picture);
    	this.picture = new JLabel(new ImageIcon(glo));
    	this.picture.setVisible(true);
    	this.add(picture);
    }

    
    public void actionPerformed(ActionEvent e){
    	this.repaint();	
    }
   
	public void mouseClicked(MouseEvent arg0) {text+="CLicked";repaint();}
	public void mouseEntered(MouseEvent arg0) {text="Enterd";}
	public void mouseExited(MouseEvent arg0) {text="Exited";}
	public void mousePressed(MouseEvent arg0) {
		if(arg0.getButton()==MouseEvent.BUTTON1){
			text="Pressed, MousePosition stored"+arg0.getButton()+" "+MouseEvent.BUTTON1;repaint();
			previousMousePositionX=arg0.getX();
			previousMousePositionY=arg0.getY();
			this.button1Pressed=true;
		}else if(arg0.getButton()==MouseEvent.BUTTON3){
			previousMousePositionX=arg0.getX();
			previousMousePositionY=arg0.getY();
			text="Pressed, MousePosition stored"+" 3";repaint();
			this.button3Pressed=true;
		}else if(arg0.getButton()==MouseEvent.BUTTON2){
			previousMousePositionX=arg0.getX();
			previousMousePositionY=arg0.getY();
			text="Pressed, MousePosition stored"+" 2";repaint();
			this.button2Pressed=true;
		}else{
			text="Pressed, MousePosition not stored " + arg0.getButton();repaint();
			this.button1Pressed=false;
			this.button3Pressed=false;
		}
		
	}
	public void mouseReleased(MouseEvent arg0) {
			if (arg0.getButton()==MouseEvent.BUTTON1){
				text="Released";repaint();
				previousMousePositionX=0;previousMousePositionY=0;
				this.button1Pressed=false;
			}else if(arg0.getButton()==MouseEvent.BUTTON3){
				this.button3Pressed=false;
			}else if(arg0.getButton()==MouseEvent.BUTTON2){
				this.button2Pressed=false;
			}else{
				text="wrong button Released";repaint();
			}
		}
	
	
	public void mouseDragged(MouseEvent arg0) {
		if((/*button1Pressed&&*/button3Pressed)||this.button2Pressed){
			//int mouseMovementX=arg0.getX()-previousMousePositionX;
			int mouseMovementY=arg0.getY()-this.previousMousePositionY;
			previousMousePositionX=arg0.getX();
			previousMousePositionY=arg0.getY();
			tu.translateOrigin(0, mouseMovementY*2, 0);
			repaint();
		}else if(button1Pressed){
			int mouseMovementX=arg0.getX()-previousMousePositionX;
			int mouseMovementY=arg0.getY()-this.previousMousePositionY;
			previousMousePositionX=arg0.getX();
			previousMousePositionY=arg0.getY();
			tu.rotateX(0.005*mouseMovementY);
			tu.rotateZ(0.005*mouseMovementX);
			this.repaint();
			text="Dragged";
		}else{
			text="wrong button Dragged "+arg0.getButton();this.repaint();
		}
	}
	public void mouseMoved(MouseEvent arg0) {
		text="moved";repaint();
	}
	
	Animation anim;
	
	/**
	 * Starts the animation for the euler angles!
	 * @param angle1 : measured in radiant (phi)
	 * @param angle2 : measured in radiant (theta) 
	 * @param angle3 : measured in radiant (psi)
	 */
	public void startAnimation(double angle1, double angle2, double angle3){
		anim = new Animation(angle1,angle2,angle3,tu,this);
		new Thread(anim).start();
	}
	public void stopAnimation(){
		anim.stop();
	}
	public void drawAngleRep() {
		for (int i = 0; i < 3; i++) {
			if(tu.getAngleRep(i)!=null){
				Dimension[] points = tu.getAngleRep(i);
		        GeneralPath polyline = new GeneralPath();
		        polyline.moveTo (points[0].width, points[0].height);
		        for ( int index = 1; index < points.length; index++ ) {
		            polyline.lineTo(points[index].width, points[index].height);
		        };
		        g2.setColor(Color.red);
		        g2.draw(polyline);
			}
		}
		
	}
	
}
class Animation implements Runnable, ActionListener{
	
	private double phi,theta,psi;
	private TUShape theShape;
	private DrawPanelIn3D var;
	private Timer timer=new Timer(50,this);
	private double speed=0.02;
	private int time=0;
	
	public Animation(double angle1, double angle2, double angle3,TUShape tus,DrawPanelIn3D a){
		phi=angle1;
		psi=angle3;
		theta=angle2;
		theShape=tus;
		var=a;
	}
	
	public void run() {
		theShape.createVisualAngleRepresentations();
		timer.start();
	}
	public void stop(){
		//var.tester=false;
		timer.stop();
		
	}
	@SuppressWarnings("unused")
	private void interrupt(int time){
		try {
			timer.wait(time);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	public void actionPerformed(ActionEvent arg0) {
		int endTime1=(int)(phi/speed);
		int endTime2=(int)(theta/speed)+endTime1;
		int endTime3=(int)(psi/speed)+endTime2;
		if(time<=endTime1){
			theShape.setEulerAngles(0, 0, time*speed);
			theShape.addPointToVisualAngle(0);
			var.repaint();
		}else if(time<=endTime2){
			theShape.addPointToVisualAngle(1);
			theShape.setEulerAngles(0, (time-endTime1)*speed,phi);
			var.repaint();
		}else if(time<=endTime3){
			theShape.addPointToVisualAngle(2);
			theShape.setEulerAngles((time-endTime2)*speed,theta,phi);
			var.repaint();
		}else{
			stop();
		}
		time++;
		if(time%5==0){
			var.tester=true;//var.drawAngleRep();
		}
	}
	
}
