/**
* This file (TUShape.java) is part of the Euler Angle Project
* 
* required files: 
* 
* used by: DrawPanelIn3D.java
* 
* ---------------------------------------------------
*Hier befinden sich alle Koordinatentransformationen. Es Existieren 4 Koordinatensysteme. 3 Davon sind 3 
*Dimensional, das vierte ist das der Graphics2D Schnittstelle(Vorsicht: linkshändiges KOS).
*KOS 1: Hierin Befinden sich alle Punkte der TUShape sowie die roten KoordinatenVektoren(mitsamt der label).
*		Es kann relativ zu KOS2 mit Hilfe der Euler winkel gedreht werden. Dazu werden alle drei Winkel
*		mit den Fields phi,psi,theta gespeichert. Damit kann dann jeder Punkt dieses KOS über die Funktion
*		transformPointToOtherCOS(Vector3D) in das KOS 2 überführt werden!
*KOS 2: Hierin befinden sich die grünen Koordinatenvektoren samt Label sowie die Visualisierungen der 3 
*		Winkel (die roten Kreise bei der Animation, welche aus 2 bis 157 Punkten bestehen). Die Ausrichtung
*		Dieses KOS wird mit Hilfe der Transformationsmatrix coSy[][] gespeichert. Alle Punkte können mit
*		der Funktion transformCOS(Vector3D) in das KOS 3 überführt werden.
*		Weiterhin kann über die rotate Funktionen jede andere Klasse dieses KOS rotieren lassen 
*		(Rotationsaxen können um konstante werde verschoben werden durch das Field ROT_AXIS).
*KOS 3: Dieses KOS ist das unveränderbare Inertialsystem. Hierhin müssen alle Vektoren transformiert werden
*		um auf das 2-dim KOS 4 projeziert zu werden! Die Projekltion übernimmt transformPoint(Vector3D)

*
* @author Simon Kraeusel
*/

package niceGraphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Vector;

@SuppressWarnings("unchecked")
public class TUShape {
	private double coSy[][]= new double[3][3];//this is the transformation matrix between the two COS
	private static Vector3D T_POINTS[][]= new Vector3D[2][8];//this creates the T
	private static Vector3D U_POINTS[][]=new Vector3D[2][8];//this creates the U
	private static Vector3D ROT_AXIS=new Vector3D(100,100,100);//the point where the two rotation axis Meet(around x and z)
	private Vector3D origin = new Vector3D(0,0,0);//translation to coordinate System in which TU is rotated
	private double phi=0;//Euler angles
	private double theta=0;
	private double psi=0;
	
	public TUShape(){
		coSy[0][0]=1;coSy[0][1]=0;coSy[0][2]=0;//this is the transformation matrix between the two COS
		coSy[1][0]=0;coSy[1][1]=1;coSy[1][2]=0;
		coSy[2][0]=0;coSy[2][1]=0;coSy[2][2]=1;
		
		T_POINTS[0][0]=new Vector3D(0,0,100);
		T_POINTS[0][1]=new Vector3D(0,0,60);
		T_POINTS[0][2]=new Vector3D(40,0,60);
		T_POINTS[0][3]=new Vector3D(40,0,0);
		T_POINTS[0][4]=new Vector3D(80,0,0);
		T_POINTS[0][5]=new Vector3D(80,0,60);
		T_POINTS[0][6]=new Vector3D(120,0,60);
		T_POINTS[0][7]=new Vector3D(120,0,100);
		for (int i = 0; i < T_POINTS[1].length; i++) {
			T_POINTS[1][i]=new Vector3D(T_POINTS[0][i].X,40,T_POINTS[0][i].Z);
		}
		U_POINTS[0][0]=new Vector3D(150,0,100);
		U_POINTS[0][1]=new Vector3D(150,0,0);
		U_POINTS[0][2]=new Vector3D(270,0,0);
		U_POINTS[0][3]=new Vector3D(270,0,100);
		U_POINTS[0][4]=new Vector3D(230,0,100);
		U_POINTS[0][5]=new Vector3D(230,0,40);
		U_POINTS[0][6]=new Vector3D(190,0,40);
		U_POINTS[0][7]=new Vector3D(190,0,100);
		for (int i = 0; i < U_POINTS[1].length; i++) {
			U_POINTS[1][i]=new Vector3D(U_POINTS[0][i].X,40,U_POINTS[0][i].Z);
		}
		this.rotateZ(-Math.PI*2.0
				/3.0);
		this.rotateX(0.5);
		this.setOrigin(-50, 300, 0);
	}
	
	/**
	 * rotates around euler angles! in _ZYZ notation.
	 * @param point
	 * @return
	 */
	private Vector3D transformPointToOtherCOS(Vector3D point){
		Vector3D temp1=new Vector3D(0,0,0);
		Vector3D temp2=new Vector3D(0,0,0);
		temp1.setX((int)(point.X*Math.cos(phi)-point.Y*Math.sin(phi)));
		temp1.setY((int)(point.X*Math.sin(phi)+point.Y*Math.cos(phi)));
		temp1.setZ(point.Z);
		
		temp2.setX((int)(temp1.X*Math.cos(theta)+temp1.Z*Math.sin(theta)));
		temp2.setY(temp1.Y);
		temp2.setZ((int)(-temp1.X*Math.sin(theta)+temp1.Z*Math.cos(theta)));
		
		temp1.setX((int)(temp2.X*Math.cos(psi)-temp2.Y*Math.sin(psi)));
		temp1.setY((int)(temp2.X*Math.sin(psi)+temp2.Y*Math.cos(psi)));
		temp1.setZ(temp2.Z);

		return temp1;
	}
	
	
	public void drawDashedLine(Graphics2D g, Color c){
		float dash1[] = {10.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 
                                              BasicStroke.CAP_BUTT, 
                                              BasicStroke.JOIN_MITER, 
                                              10.0f, dash1, 0.0f);
        g.setStroke(dashed);
        double temp = phi;
        phi=0;
        Dimension zero=transformPoint(transformCOS(transformPointToOtherCOS(new Vector3D(0,0,0))));
        Dimension eY = transformPoint(transformCOS(transformPointToOtherCOS(new Vector3D(0,200,0))));
        g.setColor(c);
        g.drawLine(zero.width, zero.height, eY.width, eY.height);
        phi=temp;

	}
	public void setEulerAngles(double z1, double x, double z2){
		this.phi=z1;
		this.theta=x;
		this.psi=z2;
	}
	public void drawEulerMovedCoordinateSystem(Graphics2D g, Color c){
		g.setColor(c);
		Dimension zero=transformPoint(transformCOS(transformPointToOtherCOS(new Vector3D(0,0,0))));
		Dimension eX = transformPoint(transformCOS(transformPointToOtherCOS(new Vector3D(200,0,0))));
		Dimension eY = transformPoint(transformCOS(transformPointToOtherCOS(new Vector3D(0,200,0))));
		Dimension eZ = transformPoint(transformCOS(transformPointToOtherCOS(new Vector3D(0,0,200))));
		g.drawLine(zero.width, zero.height, eX.width, eX.height);
		g.drawLine(zero.width, zero.height, eY.width, eY.height);
		g.drawLine(zero.width, zero.height, eZ.width, eZ.height);
		g.drawString("X", eX.width, eX.height);
		g.drawString("Y", eY.width, eY.height);
		g.drawString("Z", eZ.width, eZ.height);
	}
	public void drawCoordinateSystem(Graphics2D g, Color c){
		g.setColor(c);
		Dimension zero=transformPoint(transformCOS(new Vector3D(0,0,0)));
		Dimension eX = transformPoint(transformCOS(new Vector3D(200,0,0)));
		Dimension eY = transformPoint(transformCOS(new Vector3D(0,200,0)));
		Dimension eZ = transformPoint(transformCOS(new Vector3D(0,0,200)));
		g.drawLine(zero.width, zero.height, eX.width, eX.height);
		g.drawLine(zero.width, zero.height, eY.width, eY.height);
		g.drawLine(zero.width, zero.height, eZ.width, eZ.height);
		g.drawString("X", eX.width, eX.height);
		drawI(g,eX.width+7, eX.height+3);
		g.drawString("Y", eY.width, eY.height);
		drawI(g,eY.width+7, eY.height+3);
		g.drawString("Z", eZ.width, eZ.height);
		drawI(g,eZ.width+7, eZ.height+3);
	}
	private void drawI(Graphics2D g,int x, int y){
		g.drawLine(x, y, x+5, y);
		g.drawLine(x, y-8, x+5, y-8);
		g.drawLine(x+3, y-1, x+3, y-7);
	}
	public void setOrigin(int x, int y, int z){
		origin.setX(x);
		origin.setY(y);
		origin.setZ(z);
	}
	public void translateOrigin(int x, int y, int z){
		origin.X+=x;
		origin.Y+=y;
		origin.Z+=z;
	}
	
	private Vector3D transformCOS(Vector3D a){
		int xn=(int)(coSy[0][0]*(a.X-TUShape.ROT_AXIS.X)+coSy[1][0]*(a.Y-TUShape.ROT_AXIS.Y)+coSy[2][0]*(a.Z-TUShape.ROT_AXIS.Z));
		int yn=(int)(coSy[0][1]*(a.X-TUShape.ROT_AXIS.X)+coSy[1][1]*(a.Y-TUShape.ROT_AXIS.Y)+coSy[2][1]*(a.Z-TUShape.ROT_AXIS.Z));
		int zn=(int)(coSy[0][2]*(a.X-TUShape.ROT_AXIS.X)+coSy[1][2]*(a.Y-TUShape.ROT_AXIS.Y)+coSy[2][2]*(a.Z-TUShape.ROT_AXIS.Z));
		return new Vector3D(xn+origin.X,yn+origin.Y,zn+origin.Z);
	}
	public void drawTUShape(Graphics2D g){
		Dimension temp = new Dimension();
		int[][] xT = new int[2][9];
		int[][] yT = new int[2][9];
		int[][] xU = new int[2][9];
		int[][] yU = new int[2][9];
		for (int k = 0; k < 2; k++) {
			for (int i = 0; i < T_POINTS[k].length; i++) {
				
				Vector3D hula = transformCOS(transformPointToOtherCOS(T_POINTS[k][i]));
				temp= transformPoint(hula);
				xT[k][i]=temp.width;
				yT[k][i]=temp.height;
				
				Vector3D hulahula = transformCOS(transformPointToOtherCOS(U_POINTS[k][i]));
				temp= transformPoint(hulahula);
				xU[k][i]=temp.width;
				yU[k][i]=temp.height;
			}
			
			
			
			xT[k][8]=xT[k][0];
			yT[k][8]=yT[k][0];
			g.drawPolygon(xT[k], yT[k], 8);
			xU[k][8]=xU[k][0];
			yU[k][8]=yU[k][0];
			g.drawPolygon(xU[k], yU[k], 8);
		}	
		for (int i = 0; i < T_POINTS[0].length; i++) {
			g.setColor(Color.white);
			g.drawLine(xT[0][i], yT[0][i], xT[1][i], yT[1][i]);
			g.drawLine(xU[0][i], yU[0][i], xU[1][i], yU[1][i]);
		}
		//drawT_Surface(g);
	}
	@SuppressWarnings("unused")
	private void drawT_Surface(Graphics2D g) {
		Surface surface[]=new Surface[11];
		surface[0]=new Surface(this.transformCOS(T_POINTS[0][0]),//upper T-Front
				this.transformCOS(T_POINTS[0][7]),
				this.transformCOS(T_POINTS[0][6]),
				this.transformCOS(T_POINTS[0][1]));
		surface[1]=new Surface(this.transformCOS(T_POINTS[0][2]),//lower T-Front
				this.transformCOS(T_POINTS[0][5]),
				this.transformCOS(T_POINTS[0][4]),
				this.transformCOS(T_POINTS[0][3]));
		surface[2]=new Surface(this.transformCOS(T_POINTS[0][0]),//T-roof
				this.transformCOS(T_POINTS[1][0]),
				this.transformCOS(T_POINTS[1][7]),
				this.transformCOS(T_POINTS[0][7]));
		surface[3]=new Surface(this.transformCOS(T_POINTS[0][1]),//upper T-bottom
				this.transformCOS(T_POINTS[0][6]),
				this.transformCOS(T_POINTS[1][6]),
				this.transformCOS(T_POINTS[1][1]));
		surface[4]=new Surface(this.transformCOS(T_POINTS[0][3]),//lower T-bottom
				this.transformCOS(T_POINTS[1][3]),
				this.transformCOS(T_POINTS[1][4]),
				this.transformCOS(T_POINTS[0][4]));
		surface[5]=new Surface(this.transformCOS(T_POINTS[1][0]),//upper T-back
				this.transformCOS(T_POINTS[1][7]),
				this.transformCOS(T_POINTS[1][6]),
				this.transformCOS(T_POINTS[1][1]));
		surface[6]=new Surface(this.transformCOS(T_POINTS[1][2]),//lower T-Back
				this.transformCOS(T_POINTS[1][5]),
				this.transformCOS(T_POINTS[1][4]),
				this.transformCOS(T_POINTS[1][3]));
		surface[7]=new Surface(this.transformCOS(T_POINTS[1][0]),//left upper T-Side
				this.transformCOS(T_POINTS[0][0]),
				this.transformCOS(T_POINTS[0][1]),
				this.transformCOS(T_POINTS[1][1]));
		surface[8]=new Surface(this.transformCOS(T_POINTS[1][2]),//left lower T-Side
				this.transformCOS(T_POINTS[0][2]),
				this.transformCOS(T_POINTS[0][3]),
				this.transformCOS(T_POINTS[1][3]));
		surface[9]=new Surface(this.transformCOS(T_POINTS[0][7]),//right upper T-Side
				this.transformCOS(T_POINTS[1][7]),
				this.transformCOS(T_POINTS[1][6]),
				this.transformCOS(T_POINTS[0][6]));
		surface[10]=new Surface(this.transformCOS(T_POINTS[0][5]),//right lower T-Side
				this.transformCOS(T_POINTS[1][5]),
				this.transformCOS(T_POINTS[1][4]),
				this.transformCOS(T_POINTS[0][4]));
		Color col[]=new Color[11];
		for (int i = 0; i < col.length; i++) {
			col[i]=new Color(100+i*10,i*10,i*10);
		}
		for (int i = 0; i < surface.length; i++) {
			if(surface[i].isOnFront()){
				g.setColor(col[i]);
				g.fillPolygon(surface[i].getXPanelCoordinates(), surface[i].getYPanelCoordinates(), 4);	
			}
		}
		g.setColor(Color.white);
	}

	private Dimension transformPoint(Vector3D dummy){
	  	int xEnd=0;
	   	int yEnd=0;
    	yEnd = 250-(int)((double)dummy.Z/(dummy.Y+1300.0)*1300.0);
    	xEnd =250+(int)((double)dummy.X/(dummy.Y+1300.0)*1300.0);
    	return new Dimension(xEnd,yEnd);
    }
	public void rotateX(double xi){
		double temp1;
		double temp2;
		for (int i = 0; i < 3; i++) {
			temp1=coSy[i][1]*Math.cos(xi)-coSy[i][2]*Math.sin(xi);
			temp2=coSy[i][1]*Math.sin(xi)+coSy[i][2]*Math.cos(xi);
			coSy[i][1]=temp1;
			coSy[i][2]=temp2;
		}
	}
	public void rotateZ(double phi){
		double temp1;
		double temp2;
		for (int i = 0; i < 3; i++) {
			temp1=coSy[i][0]*Math.cos(phi)-coSy[i][1]*Math.sin(phi);
			temp2=coSy[i][0]*Math.sin(phi)+coSy[i][1]*Math.cos(phi);
			coSy[i][0]=temp1;
			coSy[i][1]=temp2;
		}
	}
	
	Vector<Vector3D>[] anglesRep = new Vector[3];
	
	public void createVisualAngleRepresentations() {
		for (int i = 0; i < anglesRep.length; i++) {
			anglesRep[i]=new Vector<Vector3D>();
		}
	}

	public void addPointToVisualAngle(int i) {
		switch (i){
		case 0:
			anglesRep[0].addElement((transformPointToOtherCOS(new Vector3D(100,0,0))));
			break;
		case 1:
			anglesRep[1].addElement((transformPointToOtherCOS(new Vector3D(0,0,100))));
			break;
		case 2:
			anglesRep[2].addElement((transformPointToOtherCOS(new Vector3D(0,100,0))));
			break;
		}
	}

	public Dimension[] getAngleRep(int index) {
		for (int i = 0; i < 3; i++) {
			if(!anglesRep[i].isEmpty()){
				if(index==i){
					Dimension[] x=new Dimension[anglesRep[i].size()];
					for (int in = 0; in < anglesRep[i].size(); in++) {
						x[in]=this.transformPoint(transformCOS((Vector3D) anglesRep[i].elementAt(in)));
					}
					return x;
				}
			}
		}
		return null;	
	}

	public void drawAngleLabel(Graphics2D g2) {
		if(theta>1.0/6.0*Math.PI){
			Dimension eZ = transformPoint(transformCOS(new Vector3D(				
					new Vector3D((int)(Math.cos(psi)*30.0),(int)(Math.sin(psi)*30.0),50).X,				
					new Vector3D((int)(Math.cos(psi)*30.0),(int)(Math.sin(psi)*30.0),50).Y,				
					new Vector3D((int)(Math.cos(psi)*30.0),(int)(Math.sin(psi)*30.0),50).Z)));
			g2.drawString("\u03d1", eZ.width , eZ.height);
		}
		if(psi>1.0/6.0*Math.PI){
			Dimension eX = transformPoint(transformCOS(new Vector3D(50,20,0)));
			g2.drawString("\u03c6", eX.width , eX.height);
		}
		if(phi>1.0/6.0*Math.PI){
			Dimension eZ = transformPoint(transformCOS(transformPointToOtherCOS(new Vector3D(20,50,0))));
			g2.drawString("\u03c8", eZ.width , eZ.height);
		}
		
	}
}
class Vector3D{
	public int X;
	public int Y;
	public int Z;

	public Vector3D(int x, int y, int z){
		X=x;
		Y=y;
		Z=z;
	}
	public void setX(int x){
		X=x;
	}
	public void setY(int y){
		Y=y;
	}
	public void setZ(int z){
		Z=z;
	}
	public void setPoint(int x, int y, int z){
		X=x;
		Y=y;
		Z=z;
	}
	public void translatePoint(int x, int y, int z){
		X+=x;
		Y+=y;
		Z+=z;
	}
}